﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using System.Threading;

namespace SWAT_USB_App
{
    public partial class Software_Form : Form
    {
        private static List<string> subGroups = new List<string>();
        private static List<Process> toInstall = new List<Process>();
        private static List<CheckBox> formCheckBoxes = new List<CheckBox>();
        private static List<RadioButton> formRadioButton = new List<RadioButton>();
        public Software_Form()
        {
            // Draws the form with a checkbox for each software specified in the text file
            InitializeComponent();
            try
            {
                Debug.appendText("Software form initializing");
                // Clears all lists
                subGroups.Clear();
                toInstall.Clear();
                formCheckBoxes.Clear();
                formRadioButton.Clear();
                // Location placeholder 
                int nextXLocation = 6, nextYLocation = 19;
                // Extracts all groups from ApplicationsList
                for (int i = 0; i < SettingsParser.ApplicationsList.Count(); i++)
                    if (SettingsParser.ApplicationsList[i].Group != null)
                    {
                        // Check if group exists already
                        bool groupExist = false;
                        for (int j = 0; j < subGroups.Count(); j++)
                            if (SettingsParser.ApplicationsList[i].Group == subGroups[j])
                            {
                                groupExist = true;
                                break;
                            }
                        if (!groupExist)
                            subGroups.Add(SettingsParser.ApplicationsList[i].Group);
                    }
                // Updates the groupbox size to hold all the checkboxes and subgroups
                this.groupBox_SoftwareList.Size = new Size(SettingsParser.softwareFormWidth - 30, 19 + SettingsParser.ApplicationsList.Count() * 23 + (subGroups.Count() * 25));
                // Updates the window size to hold all elements
                this.Size = new Size(SettingsParser.softwareFormWidth, 101 + SettingsParser.ApplicationsList.Count() * 23 + (subGroups.Count() * 25));
                // Adds a checkbox for each software item that is ungrouped, adds checkbox to list formCheckBoxes
                for (int i = 0; i < SettingsParser.ApplicationsList.Count(); i++)
                {
                    if (SettingsParser.ApplicationsList[i].Group == null)
                    {
                        // Creates a new checkbox
                        CheckBox chkBox = new CheckBox();
                        chkBox.Name = "chk_" + SettingsParser.ApplicationsList[i].Name;
                        chkBox.AutoSize = true;
                        chkBox.Text = SettingsParser.ApplicationsList[i].Name;
                        if (SettingsParser.ApplicationsList[i].Default)
                            chkBox.Checked = true;
                        chkBox.Location = new Point(nextXLocation, nextYLocation);
                        // Increments the location placeholder for the next element
                        nextYLocation += 23;
                        // Adds the checkbox to the parent groupbox
                        this.groupBox_SoftwareList.Controls.Add(chkBox);
                        // Adds the checkbox to formCheckBoxes list
                        formCheckBoxes.Add(chkBox);
                    }
                }
                // Adds a groupbox for each entry specified in subGroups as well as any applications under the group
                for (int i = 0; i < subGroups.Count(); i++)
                {
                    // Sets the internal location coordinates for the next element
                    int subNextXLocation = 6;
                    int subNextYLocation = 19;
                    // Creates a new groupbox
                    GroupBox grpBox = new GroupBox();
                    grpBox.Name = "grp_" + subGroups[i];
                    grpBox.Text = subGroups[i];
                    // Finds the number of applications under the group
                    int numberOfSubentries = 0;
                    for (int j = 0; j < SettingsParser.ApplicationsList.Count(); j++)
                        if (SettingsParser.ApplicationsList[j].Group == subGroups[i])
                        {
                            // If the group matches, creates a new radiobutton
                            numberOfSubentries++;
                            RadioButton rdoBtn = new RadioButton();
                            rdoBtn.Name = "rdo_" + SettingsParser.ApplicationsList[j].Name;
                            rdoBtn.AutoSize = true;
                            rdoBtn.Text = SettingsParser.ApplicationsList[j].Name;
                            if (SettingsParser.ApplicationsList[j].Default)
                                rdoBtn.Checked = true;
                            rdoBtn.Location = new Point(subNextXLocation, subNextYLocation);
                            // Increments the location placeholder for the next element
                            subNextYLocation += 23;
                            // Adds the radiobutton to the parent groupbox
                            grpBox.Controls.Add(rdoBtn);
                            // Adds the radiobutton to formRadioButton list
                            formRadioButton.Add(rdoBtn);
                        }
                    grpBox.Size = new Size(SettingsParser.softwareFormWidth - 42, 19 + numberOfSubentries * 23);
                    grpBox.Location = new Point(nextXLocation, nextYLocation);
                    nextYLocation += 25 + numberOfSubentries * 23;
                    // Adds the created groupbox to the parent groupbox
                    this.groupBox_SoftwareList.Controls.Add(grpBox);
                }
            }
            catch (Exception ex)
            {
                Debug.appendText("Exception Thrown: " + ex.ToString());
                MessageBox.Show(ex.ToString());
            }
        }
        private void updateToInstallList()
        {
            try
            {
                Debug.appendText("Updating list of processes to run from list of software checked");
                // Updates list toInstall with processes for each software checked in formCheckBoxes
                for (int i = 0; i < formCheckBoxes.Count(); i++)
                {
                    if (formCheckBoxes[i].Checked)
                    {
                        string[] temp = null;
                        // Pulls the setup locations
                        for (int j = 0; j < SettingsParser.ApplicationsList.Count(); j++)
                            if (SettingsParser.ApplicationsList[j].Name == formCheckBoxes[i].Text)
                            {
                                temp = SettingsParser.ApplicationsList[j].SetupFileLocation;
                                break;
                            }
                        for (int j = 0; j < temp.Count(); j += 2)
                        {
                            Process proc = new Process();
                            proc.StartInfo.FileName = Initialization.pathToSWATDrive + temp[j];
                            proc.StartInfo.Arguments = temp[j + 1];
                            toInstall.Add(proc);
                        }
                    }
                }
                // Updates list toInstall with processes for each software checked in formRadioButton
                for (int i = 0; i < formRadioButton.Count(); i++)
                {
                    if (formRadioButton[i].Checked)
                    {
                        string[] temp = null;
                        // Pulls the setup locations
                        for (int j = 0; j < SettingsParser.ApplicationsList.Count(); j++)
                            if (SettingsParser.ApplicationsList[j].Name == formRadioButton[i].Text)
                            {
                                temp = SettingsParser.ApplicationsList[j].SetupFileLocation;
                                break;
                            }
                        for (int j = 0; j < temp.Count(); j += 2)
                        {
                            Process proc = new Process();
                            proc.StartInfo.FileName = Initialization.pathToSWATDrive + temp[j];
                            proc.StartInfo.Arguments = temp[j + 1];
                            toInstall.Add(proc);
                        }
                    }
                }
            }
            catch (Exception e)
            {
                Debug.appendText("Exception Thrown: " + e.ToString());
                MessageBox.Show(e.ToString());
            }
        }
        private void startSoftwareInstaller(List<Process> toInstall, int ID)
        {
            Debug.appendText("Starting to install softwares from list of processes");
            try
            {
                //this.WindowState = FormWindowState.Minimized;
                // Goes through list toInstall and runs each process after the previous one ends
                int tempID = ID;
                if (tempID < toInstall.Count)
                {
                    Debug.appendText("Running setup " + toInstall[ID].StartInfo.FileName + " with arguments " + toInstall[ID].StartInfo.Arguments);
                    toInstall[ID].Start();
                    while (!toInstall[ID].HasExited)
                    {
                        // Waits for installer to finish before starting the next one
                        Thread.Sleep(3000);
                    }
                    if (toInstall[ID].HasExited)
                    {
                        Debug.appendText("Setup is detected as finished, running next setup");
                        tempID++;
                        startSoftwareInstaller(toInstall, tempID);
                    }
                }
                //this.WindowState = FormWindowState.Normal;
            }
            catch (Exception e)
            {
                Debug.appendText("Exception Thrown: " + e.ToString());
                MessageBox.Show(e.ToString());
            }
        }
        private void btn_Ok_Click(object sender, EventArgs e)
        {
            updateToInstallList();
            startSoftwareInstaller(toInstall, 0);
            this.Close();
        }
        private void btn_Cancel_Click(object sender, EventArgs e)
        {
            Debug.appendText("Closing software form");
            this.Close();
        }
        private void btn_Reset_Click(object sender, EventArgs e)
        {
            for (int i = 0; i < formCheckBoxes.Count(); i++)
                formCheckBoxes[i].Checked = false;
            for (int i = 0; i < formRadioButton.Count(); i++)
                formRadioButton[i].Checked = false;
        }
    }
}
